<?php
/* --------------------------------------------------------------
   AfterbuyLogger.inc.php 2020-04-21
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

use Gambio\Core\Logging\LoggerBuilder;

class AfterbuyLogger
{
    public const LOGFILE       = 'afterbuy';
    
    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;
    
    
    public function __construct()
    {
        /** @var LoggerBuilder $loggerBuilder */
        $loggerBuilder = LegacyDependencyContainer::getInstance()->get(LoggerBuilder::class);
        $this->logger = $loggerBuilder->omitRequestData()->changeNamespace(static::LOGFILE)->build();
    }
    
    
    public function notice($message)
    {
        $this->logger->notice($message);
    }
}
